<?php

namespace App\Http\Controllers;

use GuzzleHttp\Client;
use Illuminate\Http\Request;

class PerusahaanController extends Controller
{
    public function index(){
        $perusahaan = perusahaan::orderBy('id', 'desc')->get();
        return response()->json($perusahaan);
    }

    public function tambah(){
      $client = new Client();

      $data['nama_perusahaan'] = $request->nama_perusahaan;
      $data['email_perusahaan'] = $request->email_perusahaan;
      $data['kategori'] = $request->kategori;
      $data['deskripsi'] = $request->deskripsi;
      $client->post('localhost:8040/api/add/',
          ['form_params' => $data]);
      return redirect('/index');
    }

    public function view($id) {
        $perusahaan = perusahaan::find($id);
        return response()->json($perusahaan);
    }

    public function add(Request $request) {
        $perusahaan = new perusahaan();

        $perusahaan->nama_perusahaan= $request->nama_perusahaan;
        $perusahaan->email_perusahaan = $request->email_perusahaan;
        $perusahaan->kategori = $request->kategori;
        $perusahaan->deskripsi = $request->deskripsi;

        $perusahaan>save();
    }

    public function update(Request $request, $id) {
        $perusahaan = perusahaan::find($id);

        $perusahaan->nama_perusahaan = $request->nama_perusahaan;
        $perusahaan->email_perusahaan = $request->email_perusahaan;
        $perusahaan->kategori = $request->kategori;
        $perusahaan->deskripsi = $request->deskripsi;

        $perusahaan->save();
    }

    public function delete($id) {
        $perusahaan = perusahaan::find($id);

        $perusahaan->delete();
    }
}
